# ---------------------------------------------------------------------------------------------------------------------
# PARAMETRY WYMAGANE
# Konieczne jest podanie wartości dla każdego z tych parametrów.
# ---------------------------------------------------------------------------------------------------------------------

variable "allowed_repos_branches" {
  description = "Repozytoria i gałęzie GitHub, które mogą przyjmować tę rolę IAM."
  type = list(object({
    org    = string
    repo   = string
    branch = string
  }))
  # Przykład:
  # allowed_repos_branches = [
  #   {
  #     org    = "brikis98"
  #     repo   = "terraform-up-and-running-code"
  #     branch = "main"
  #   }
  # ]
}

# ---------------------------------------------------------------------------------------------------------------------
# PARAMETRY OPCJONALNE
# Te parametry mają rozsądne wartości domyślne.
# ---------------------------------------------------------------------------------------------------------------------

variable "name" {
  description = "Nazwa używana we wszystkich zasobach utworzonych przez ten moduł"
  type        = string
  default     = "github-actions-oidc-example"
}

